function post_click(url){
  let decodable_token = "<REPLACE_ME>";
  let endpoint_url = "<REPLACE_ME>";

  // Creating a XHR object
  let xhr = new XMLHttpRequest();
  let d = new Date();

  // open a connection
  xhr.open("POST", endpoint_url, true);

  // Set the request header i.e. which type of content you are sending
  xhr.setRequestHeader("Content-Type", "application/json");
  xhr.setRequestHeader("Authorization", "Bearer "+ decodable_token);

  // Converting JSON data to string
  var data = JSON.stringify({"events": [{
      "click_epoch": d.getTime(),
      "request_url": url,
      "visitor_id": "b56afbf3-321f-49c1-919c-b2ea3e550b07",
      "UTC_offset": (d.getTimezoneOffset()/60*-1),
      "browser_agent": navigator.userAgent}]});
  console.log(data);
  // Sending data with the request
  xhr.send(data);
}

let monitors = [
  'https://www.demoblaze.com/catalog/monitors/ASUS-Full-HD',
  'https://www.demoblaze.com/catalog/monitors/Apple-monitor-24',
];
let laptops = [
  'https://www.demoblaze.com/catalog/laptops/MacBook-Pro',
  'https://www.demoblaze.com/catalog/laptops/2017-Dell-15.6-Inch',
  'https://www.demoblaze.com/catalog/laptops/Dell-i7-8gb',
  'https://www.demoblaze.com/catalog/laptops/MacBook-air',
  'https://www.demoblaze.com/catalog/laptops/Sony-vaio-i7',
  'https://www.demoblaze.com/catalog/laptops/Sony-vaio-i5',
];
let phones = [
  'https://www.demoblaze.com/catalog/phones/Samsung-galaxy-s6',
  'https://www.demoblaze.com/catalog/phones/Nokia-lumia-1520',
  'https://www.demoblaze.com/catalog/phones/Nexus-6',
  'https://www.demoblaze.com/catalog/phones/Samsun-galaxy-s7',
  'https://www.demoblaze.com/catalog/phones/Iphone-6-32gb',
  'https://www.demoblaze.com/catalog/phones/Sony-xperia-z5',
  'https://www.demoblaze.com/catalog/phones/HTC-One-M9',
];

async function bulk_items(ary){
  let minutes = 5;

  for(var i=1;i<(minutes*60);i++){
    var url = ary[Math.floor(Math.random()*ary.length)];
    post_click(url);
    console.log('Bulk count: ' + i);
    await sleep(10);
  }
}

async function bulk_items_all(){
  let clicks = 5000;

  for(var i=0;i<clicks;i++){
    var ary = [monitors, laptops, phones];
    var category = ary[Math.floor(Math.random()*ary.length)];
    var item = category[Math.floor(Math.random()*category.length)];
    post_click(item);
    await sleep(300);
  }
}

function sleep(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}